// Load sample travel times if the CSV is not available
function loadTravelTimes() {
    travelTimes = {};
    const matriceTemps = {
        // multiplicateur GIMP pixels / secondes : 1.315
        "Asandam": { "Asandam": 0, "Bapa": 1292, "Gbuzoubou": 1237, "Molmed": 1288, "Grelic": 687 },
        "Bapa": { "Bapa": 0, "Bohkh": 769, "Gbuzoubou": 98, "Asandam": 1292, "Shaif": 1175 },
        "Bismed": { "Bismed": 0, "Grelic": 493, "Shaif": 298, "Mosaiikoubi": 340 },
        "Bohkh": { "Bohkh": 0, "Bapa": 769, "Elah": 1315, "Rezealvan": 963 },
        "Brondostin": { "Brondostin": 0, "Klioereos": 418, "Molmed": 825, "Rezealvan": 693, "Molam": 1029 },
        "Elah": { "Elah": 0, "Bohkh": 1315, "Mahhir": 574, "Meham": 528 },
        "Gbuzoubou": { "Gbuzoubou": 0, "Bapa": 98, "Klioereos": 503, "Asandam": 1237, "Raafa": 863 },
        "Grelic": { "Grelic": 0, "Bismed": 493, "Ntembe": 577, "Wamad": 752, "Asandam": 687 },
        "Klioereos": { "Klioereos": 0, "Wamad": 1138, "Gbuzoubou": 503, "Brondostin": 418, "Yazaiertab": 1243 },
        "Mahhir": { "Mahhir": 0, "Phokles": 558, "Raafa": 134, "Elah": 574, "Shaif": 424 },
        "Masafa": { "Masafa": 0, "Yazaiertab": 143, "Raafa": 173, "Wamad": 236, "Phokles": 790 },
        "Meham": { "Meham": 0, "Molmed": 152, "Ntembe": 1067, "Elah": 528, "Ondeasalic": 740 },
        "Molmed": { "Molmed": 0, "Brondostin": 825, "Meham": 152, "Asandam": 1288, "Yazaiertab": 352 },
        "Molam": { "Molam": 0, "Yazaiertab": 9999, "Brondostin": 9999, "Rezealvan": 9999 },
        // "Molam": { "Molam": 0, "Yazaiertab": 220, "Brondostin": 1029, "Rezealvan": 336 },
        "Mosaiikoubi": { "Mosaiikoubi": 0, "Wamad": 423, "Bismed": 340, "Ondeasalic": 821 },
        "Ntembe": { "Ntembe": 0, "Rezealvan": 1137, "Meham": 1067, "Grelic": 577, "Rawad": 909 },
        "Ondeasalic": { "Ondeasalic": 0, "Mosaiikoubi": 821, "Phokles": 282, "Rawad": 758, "Meham": 740 },
        "Phokles": { "Phokles": 0, "Ondeasalic": 282, "Rawad": 614, "Masafa": 790, "Mahhir": 558 },
        "Raafa": { "Raafa": 0, "Masafa": 9999, "Gbuzoubou": 9999, "Mahhir": 9999, "Rawad": 9999 },
        // "Raafa": { "Raafa": 0, "Masafa": 173, "Gbuzoubou": 863, "Mahhir": 134, "Rawad": 241 },
        "Rawad": { "Rawad": 0, "Ntembe": 909, "Phokles": 614, "Raafa": 241, "Ondeasalic": 758 },
        "Rezealvan": { "Rezealvan": 0, "Molam": 336, "Brondostin": 693, "Bohkh": 963, "Ntembe": 1137 },
        // "Shaif": { "Shaif": 0, "Bapa": 1175, "Bismed": 298, "Mahhir": 424 },
        "Shaif": { "Shaif": 0, "Bapa": 9999, "Bismed": 9999, "Mahhir": 9999 },
        "Wamad": { "Wamad": 0, "Grelic": 752, "Masafa": 236, "Mosaiikoubi": 423, "Klioereos": 1138 },
        "Yazaiertab": { "Yazaiertab": 0, "Molmed": 352, "Molam": 220, "Masafa": 143, "Klioereos": 1243 }
    };
    console.log(`Total number of towns: ${Object.keys(matriceTemps).length}`);
    Object.keys(matriceTemps).forEach(fromCity => {
        travelTimes[fromCity] = {};
        Object.keys(matriceTemps).forEach(toCity => {
            travelTimes[fromCity][toCity] = (matriceTemps[fromCity][toCity] !== undefined)
                ? matriceTemps[fromCity][toCity]
                : Infinity;
        });
        travelTimes[fromCity][fromCity] = 0;
    });
}

// Sample data if the HTML table is not accessible
function loadData() {
    // empty cities : Achirnolm, bleim, cen, naussimore, tograd, Eson, Taling, Tograd, Haric, Flelnenberg, Floswowan, Prelm, Stosson, Nelm
    // Sowen, Ornoria, endidrelic, staling, Zorafa
    // TO DO :
    cities = ['Asandam','Bapa', 'Bismed', 'Bohkh', 'Brondostin', 'Elah', 'Gbuzoubou', 'Grelic',
        'Klioereos', 'Mahhir', 'Masafa', 'Meham', 'Molam', 'Molmed', 'Mosaiikoubi', 'Ntembe', 'Ondeasalic',
        'Phokles', 'Raafa', 'Rawad', 'Rezealvan', 'Shaif','Wamad', 'Yazaiertab']
    console.log(cities);
    connections = {};
    cities.forEach(city => {
        connections[city] = {};
        cities.forEach(otherCity => {
            connections[city][otherCity] = Infinity;
        });
        connections[city][city] = 0;
    });
    // configuration for connections
    connections['Asandam']['Bapa'] = 1;
    connections['Asandam']['Gbuzoubou'] = 1;
    connections['Asandam']['Molmed'] = 1;
    connections['Asandam']['Grelic'] = 1;

    connections['Bapa']['Bohkh'] = 1;
    connections['Bapa']['Gbuzoubou'] = 1;
    connections['Bapa']['Asandam'] = 1;
    connections['Bapa']['Shaif'] = 1;

    connections['Bismed']['Grelic'] = 1;
    connections['Bismed']['Shaif'] = 1;
    connections['Bismed']['Mosaiikoubi'] = 1;
    connections['Bismed'][''] = 1;

    connections['Bohkh']['Bapa'] = 1;
    connections['Bohkh']['Elah'] = 1;
    connections['Bohkh']['Rezealvan'] = 1;
    connections['Bohkh'][''] = 1;

    connections['Brondostin']['Klioereos'] = 1;
    connections['Brondostin']['Molmed'] = 1;
    connections['Brondostin']['Rezealvan'] = 1;
    connections['Brondostin']['Molam'] = 1;

    connections['Elah']['Bohkh'] = 1;
    connections['Elah']['Mahhir'] = 1;
    connections['Elah']['Meham'] = 1;
    connections['Elah'][''] = 1;

    connections['Gbuzoubou']['Bapa'] = 1;
    connections['Gbuzoubou']['Klioereos'] = 1;
    connections['Gbuzoubou']['Asandam'] = 1;
    connections['Gbuzoubou']['Raafa'] = 1;

    connections['Grelic']['Bismed'] = 1;
    connections['Grelic']['Ntembe'] = 1;
    connections['Grelic']['Wamad'] = 1;
    connections['Grelic']['Asandam'] = 1;

    connections['Klioereos']['Wamad'] = 1;
    connections['Klioereos']['Gbuzoubou'] = 1;
    connections['Klioereos']['Brondostin'] = 1;
    connections['Klioereos']['Yazaiertab'] = 1;

    connections['Mahhir']['Phokles'] = 1;
    connections['Mahhir']['Raafa'] = 1;
    connections['Mahhir']['Elah'] = 1;
    connections['Mahhir']['Shaif'] = 1;

    connections['Masafa']['Yazaiertab'] = 1;
    connections['Masafa']['Raafa'] = 1;
    connections['Masafa']['Wamad'] = 1;
    connections['Masafa']['Phokles'] = 1;

    connections['Meham']['Molmed'] = 1;
    connections['Meham']['Ntembe'] = 1;
    connections['Meham']['Elah'] = 1;
    connections['Meham']['Ondeasalic'] = 1;

    connections['Molmed']['Brondostin'] = 1;
    connections['Molmed']['Meham'] = 1;
    connections['Molmed']['Asandam'] = 1;
    connections['Molmed']['Yazaiertab'] = 1;

// Molam
// connections['Molam']['Yazaiertab'] = 1;
// connections['Molam']['Brondostin'] = 1;
// connections['Molam'][''] = 1;
// connections['Molam'][''] = 1;

    connections['Mosaiikoubi']['Wamad'] = 1;
    connections['Mosaiikoubi']['Bismed'] = 1;
    connections['Mosaiikoubi']['Ondeasalic'] = 1;
    connections['Mosaiikoubi'][''] = 1;

    connections['Ntembe']['Rezealvan'] = 1;
    connections['Ntembe']['Meham'] = 1;
    connections['Ntembe']['Grelic'] = 1;
    connections['Ntembe']['Rawad'] = 1;

    connections['Ondeasalic']['Mosaiikoubi'] = 1;
    connections['Ondeasalic']['Phokles'] = 1;
    connections['Ondeasalic']['Rawad'] = 1;
    connections['Ondeasalic']['Meham'] = 1;

    connections['Phokles']['Ondeasalic'] = 1;
    connections['Phokles']['Rawad'] = 1;
    connections['Phokles']['Masafa'] = 1;
    connections['Phokles']['Mahhir'] = 1;

// Raafa
// connections['Raafa']['Masafa'] = 1;
// connections['Raafa']['Gbuzoubou'] = 1;
// connections['Raafa']['Mahhir'] = 1;
// connections['Raafa']['Rawad'] = 1;

    connections['Rawad']['Ntembe'] = 1;
    connections['Rawad']['Phokles'] = 1;
    connections['Rawad']['Raafa'] = 1;
    connections['Rawad']['Ondeasalic'] = 1;

    connections['Rezealvan']['Molam'] = 1;
    connections['Rezealvan']['Brondostin'] = 1;
    connections['Rezealvan']['Bohkh'] = 1;
    connections['Rezealvan']['Ntembe'] = 1;

// Shaif
// connections['Shaif']['Bapa'] = 1;
// connections['Shaif']['Bismed'] = 1;
// connections['Shaif']['Mahhir'] = 1;
// connections['Shaif'][''] = 1;

    connections['Wamad']['Grelic'] = 1;
    connections['Wamad']['Masafa'] = 1;
    connections['Wamad']['Mosaiikoubi'] = 1;
    connections['Wamad']['Klioereos'] = 1;

    connections['Yazaiertab']['Molmed'] = 1;
    connections['Yazaiertab']['Molam'] = 1;
    connections['Yazaiertab']['Masafa'] = 1;
    connections['Yazaiertab']['Klioereos'] = 1;

    // Ces appels doivent se faire seulement si les éléments existent
    if (document.getElementById('startCity') && document.getElementById('endCity')) {
        populateDropdowns();
    }
    loadTravelTimes();
}

// Populate city dropdowns
function populateDropdowns() {
    const startSelect = document.getElementById('startCity');
    const endSelect = document.getElementById('endCity');
    startSelect.innerHTML = '';
    endSelect.innerHTML = '';
    cities.forEach(city => {
        startSelect.add(new Option(city, city));
        endSelect.add(new Option(city, city));
    });
    if (cities.length > 1) {
        endSelect.selectedIndex = 1;
    }
}
