
// Coordinates of cities on the PNG map (en pixels)
// Tu devras mettre à jour ces valeurs en fonction des coordonnées réelles
let cityCoordinates = {
    "Towns* : These towns are not served by airships": { x: 150, y: 1 }, //Legend
    "Achirnolm*": { x: 504, y: 404 }, //non desservie
    "Ammeric*": { x: 583, y: 791 }, //non desservie
    "Asandam": { x: 34, y: 425 },
    "Bapa": { x: 968, y: 112 },
    "Bismed": { x: 632, y: 1000 },
    "Bleim*": { x: 86, y: 473 }, //non desservie
    "Bohkh": { x: 376, y: 105 },
    "Brondostin": { x: 845, y: 36 },
    "Cen*": { x: 301, y: 1005 }, //non desservie
    "Elah": { x: 693, y: 1051 },
    "Endidrelic*": { x: 77, y: 636 }, //non desservie
    "Eson*": { x: 511, y: 505 }, //non desservie
    "Flelnenberg*": { x: 454, y: 955 }, //non desservie
    "Floswowan*": { x: 867, y: 496 }, //non desservie
    "Gbuzoubou": { x: 901, y: 75 },
    "Grelic": { x: 512, y: 645 },
    "Haric*": { x: 443, y: 568 }, //non desservie
    "Klioereos": { x: 526, y: 31 },
    "Mahhir": { x: 934, y: 691 },
    "Masafa": { x: 1004, y: 855 },
    "Meham": { x: 969, y: 758 },
    "Molam": { x: 1038, y: 792 },
    "Molmed": { x: 988, y: 643 },
    "Mosaiikoubi": { x: 775, y: 784 },
    "Naussimore*": { x: 97, y: 359 }, //non desservie
    "Nelm*": { x: 235, y: 921 }, //non desservie
    "Ntembe": { x: 173, y: 924 },
    "Ondeasalic": { x: 975, y: 193 },
    "Ornoria*": { x: 157, y: 530 }, //non desservie
    "Phokles": { x: 784, y: 294 },
    "Prelm*": { x: 535, y: 294 }, //non desservie
    "Raafa": { x: 1026, y: 726 },
    "Rawad": { x: 841, y: 756 },
    "Rezealvan": { x: 952, y: 552 },
    "Shaif": { x: 864, y: 1003 },
    "Staling*": { x: 71, y: 558 }, //non desservie
    "Stosson*": { x: 400, y: 990 }, //non desservie
    "Sowen*": { x: 621, y: 350 }, //non desservie
    "Taling*": { x: 534, y: 574 }, //non desservie
    "Tograd*": { x: 289, y: 231 }, //non desservie
    "Wamad": { x: 1073, y: 692 },
    "Yazaiertab": { x: 903, y: 896 },
    "Zorafa": { x: 790, y: 896 }
};


// Load travel times if the CSV is not available
function loadTravelTimes() {
    travelTimes = {};

    // Facteur de conversion pixels vers secondes
    const pixelToSecondsFactor = 1.34;

    // Initialiser la matrice pour toutes les villes
    Object.keys(cityCoordinates).forEach(fromCity => {
        // Ignorer la légende
        if (fromCity === "Towns* : These towns are not served by airships") return;

        travelTimes[fromCity] = {};
        Object.keys(cityCoordinates).forEach(toCity => {
            if (toCity === "Towns* : These towns are not served by airships") return;

            travelTimes[fromCity][toCity] = (fromCity === toCity) ? 0 : Infinity;
        });
    });

    // Calculer les temps de trajet pour les villes connectées
    Object.keys(connections).forEach(fromCity => {
        Object.keys(connections[fromCity]).forEach(toCity => {
            if (connections[fromCity][toCity] === 1 &&
                cityCoordinates[fromCity] &&
                cityCoordinates[toCity] &&
                fromCity !== "Towns* : These towns are not served by airships" &&
                toCity !== "Towns* : These towns are not served by airships") {

                // Calculer la distance en pixels
                const dx = cityCoordinates[toCity].x - cityCoordinates[fromCity].x;
                const dy = cityCoordinates[toCity].y - cityCoordinates[fromCity].y;
                const distancePixels = Math.sqrt(dx * dx + dy * dy);

                // Convertir en secondes
                let travelTimeSeconds = Math.round(distancePixels * pixelToSecondsFactor);

                // Assigner le temps de trajet (bidirectionnel)
                travelTimes[fromCity][toCity] = travelTimeSeconds;
                travelTimes[toCity][fromCity] = travelTimeSeconds;
            }
        });
    });

    console.log(`Temps de trajet calculés dynamiquement pour ${Object.keys(travelTimes).length} villes`);
}

// Load data
function loadData() {
    // empty cities : Achirnolm, bleim, cen, naussimore, tograd, Eson, Taling, Tograd, Haric, Flelnenberg, Floswowan, Prelm, Stosson, Nelm
    // Sowen, Ornoria, endidrelic, staling
    // TO DO :
    cities = ['Asandam','Bapa', 'Bismed', 'Bohkh', 'Brondostin', 'Elah', 'Gbuzoubou', 'Grelic',
        'Klioereos', 'Mahhir', 'Masafa', 'Meham', 'Molam', 'Molmed', 'Mosaiikoubi', 'Ntembe', 'Ondeasalic',
        'Phokles', 'Raafa', 'Rawad', 'Rezealvan', 'Shaif','Wamad', 'Yazaiertab', 'Zorafa']
    console.log(cities);
    connections = {};
    cities.forEach(city => {
        connections[city] = {};
        cities.forEach(otherCity => {
            connections[city][otherCity] = Infinity;
        });
        connections[city][city] = 0;
    });
    // configuration for connections
    connections['Asandam']['Meham'] = 1;
    connections['Asandam']['Ntembe'] = 1;
    connections['Asandam']['Bohkh'] = 1;
    connections['Asandam']['Yazaiertab'] = 1;

    connections['Bapa']['Raafa'] = 1;
    connections['Bapa']['Phokles'] = 1;
    connections['Bapa']['Gbuzoubou'] = 1;
    connections['Bapa']['Rezealvan'] = 1;

    connections['Bismed']['Grelic'] = 1;
    connections['Bismed']['Molmed'] = 1;
    connections['Bismed']['Mahhir'] = 1;
    connections['Bismed']['Masafa'] = 1;

    connections['Bohkh']['Asandam'] = 1;
    connections['Bohkh']['Gbuzoubou'] = 1;
    connections['Bohkh']['Rezealvan'] = 1;
    connections['Bohkh']['Mahhir'] = 1;

    connections['Brondostin']['Gbuzoubou'] = 1;
    connections['Brondostin']['Molmed'] = 1;
    connections['Brondostin']['Phokles'] = 1;
    connections['Brondostin']['Molam'] = 1;

    connections['Elah']['Raafa'] = 1;
    connections['Elah']['Molmed'] = 1;
    connections['Elah']['Phokles'] = 1;
    connections['Elah']['Masafa'] = 1;

    connections['Gbuzoubou']['Brondostin'] = 1;
    connections['Gbuzoubou']['Bapa'] = 1;
    connections['Gbuzoubou']['Bohkh'] = 1;
    connections['Gbuzoubou']['Masafa'] = 1;

    connections['Grelic']['Zorafa'] = 1;
    connections['Grelic']['Mahhir'] = 1;
    connections['Grelic']['Bismed'] = 1;
    connections['Grelic']['Ondeasalic'] = 1;

    connections['Klioereos']['Rawad'] = 1;
    connections['Klioereos']['Mosaiikoubi'] = 1;
    connections['Klioereos']['Molmed'] = 1;

    connections['Mahhir']['Grelic'] = 1;
    connections['Mahhir']['Bohkh'] = 1;
    connections['Mahhir']['Bismed'] = 1;
    connections['Mahhir']['Ntembe'] = 1;

    connections['Masafa']['Rezealvan'] = 1;
    connections['Masafa']['Bismed'] = 1;
    connections['Masafa']['Elah'] = 1;
    connections['Masafa']['Gbuzoubou'] = 1;

    connections['Meham']['Rawad'] = 1;
    connections['Meham']['Raafa'] = 1;
    connections['Meham']['Molam'] = 1;
    connections['Meham']['Asandam'] = 1;

    connections['Molmed']['Elah'] = 1;
    connections['Molmed']['Klioereos'] = 1;
    connections['Molmed']['Brondostin'] = 1;
    connections['Molmed']['Bismed'] = 1;

// Molam : pas de tour
    connections['Molam']['Mosaiikoubi'] = Infinity;
    connections['Molam']['Meham'] = Infinity;
    connections['Molam']['Brondostin'] = Infinity;
    connections['Molam']['Shaif'] = Infinity;

    connections['Mosaiikoubi']['Ntembe'] = 1;
    connections['Mosaiikoubi']['Zorafa'] = 1;
    connections['Mosaiikoubi']['Klioereos'] = 1;
    connections['Mosaiikoubi']['Molam'] = 1;

    connections['Ntembe']['Mosaiikoubi'] = 1;
    connections['Ntembe']['Asandam'] = 1;
    connections['Ntembe']['Mahhir'] = 1;

    connections['Ondeasalic']['Grelic'] = 1;
    connections['Ondeasalic']['Phokles'] = 1;
    connections['Ondeasalic']['Rawad'] = 1;
    connections['Ondeasalic']['Wamad'] = 1;

    connections['Phokles']['Ondeasalic'] = 1;
    connections['Phokles']['Brondostin'] = 1;
    connections['Phokles']['Elah'] = 1;
    connections['Phokles']['Bapa'] = 1;

    connections['Raafa']['Zorafa'] = 1;
    connections['Raafa']['Meham'] = 1;
    connections['Raafa']['Elah'] = 1;
    connections['Raafa']['Bapa'] = 1;

    connections['Rawad']['Klioereos'] = 1;
    connections['Rawad']['Zorafa'] = 1;
    connections['Rawad']['Meham'] = 1;
    connections['Rawad']['Ondeasalic'] = 1;

    connections['Rezealvan']['Bapa'] = 1;
    connections['Rezealvan']['Masafa'] = 1;
    connections['Rezealvan']['Shaif'] = 1;
    connections['Rezealvan']['Bohkh'] = 1;

// Shaif: pas de tour
    connections['Shaif']['Wamad'] = Infinity;
    connections['Shaif']['Rezealvan'] = Infinity;
    connections['Shaif']['Molam'] = Infinity;

    connections['Wamad']['Ondeasalic'] = 1;
    connections['Wamad']['Shaif'] = 1;
    connections['Wamad']['Yazaiertab'] = 1;

    connections['Yazaiertab']['Asandam'] = 1;
    connections['Yazaiertab']['Wamad'] = 1;

    connections['Zorafa']['Rawad'] = 1;
    connections['Zorafa']['Grelic'] = 1;
    connections['Zorafa']['Raafa'] = 1;
    connections['Zorafa']['Mosaiikoubi'] = 1;

    // Ces appels doivent se faire seulement si les éléments existent
    if (document.getElementById('startCity') && document.getElementById('endCity')) {
        populateDropdowns();
    }
   // loadTravelTimes(); // Appel de la fonction modifiée
}