<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calculateur d'Itinéraire</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            color: #333;
            text-align: center;
        }
        .calculator-container {
            background-color: #f5f5f5;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        select {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
        }
        button {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            display: block;
            margin: 20px auto;
        }
        button:hover {
            background-color: #45a049;
        }
        #result {
            margin-top: 20px;
            padding: 15px;
            border-left: 4px solid #4CAF50;
            background-color: #e7f7e7;
            display: none;
        }
        .path {
            font-weight: bold;
            margin: 10px 0;
        }
        .distance {
            font-size: 18px;
            color: #333;
        }
        .error {
            color: red;
            font-style: italic;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 25px 0;
            font-size: 14px;
        }
        th, td {
            padding: 8px;
            text-align: center;
            border: 1px solid #ddd;
        }
        th {
            background-color: #f2f2f2;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
    </style>
</head>
<body>
    <h1>Calculateur du Plus Court Chemin - Carte de Veloren</h1>
    
    <div class="calculator-container">
        <div class="form-group">
            <label for="startCity">Ville de départ:</label>
            <select id="startCity"></select>
        </div>
        
        <div class="form-group">
            <label for="endCity">Ville d'arrivée:</label>
            <select id="endCity"></select>
        </div>
        
        <button id="calculateBtn">Calculer l'itinéraire</button>
        
        <div id="result">
            <h3>Résultat:</h3>
            <div class="path" id="pathResult"></div>
            <div class="distance" id="distanceResult"></div>
        </div>
    </div>
    
    <div id="dataTable"></div>
    
    <script>
        // Cette fonction sera appelée quand la page est chargée
        document.addEventListener('DOMContentLoaded', function() {
            // Récupération du tableau depuis votre page
            fetchRouteTable();
            
            // Ajout d'un écouteur d'événement pour le bouton de calcul
            document.getElementById('calculateBtn').addEventListener('click', calculateShortestPath);
        });
        
        // Définition des variables globales pour stocker les données
        let cities = [];
        let connections = {};
        
        // Fonction pour récupérer le tableau de données
        function fetchRouteTable() {
            // URL de votre tableau de données
            const tableUrl = 'https://jansen.freeboxos.fr/nextcloud/index.php/apps/cms_pico/pico/veloren/routes-table/';
            
            fetch(tableUrl)
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Erreur lors de la récupération du tableau de données');
                    }
                    return response.text();
                })
                .then(html => {
                    parseTableData(html);
                })
                .catch(error => {
                    console.error('Erreur:', error);
                    // En cas d'erreur, charger des données d'exemple
                    loadSampleData();
                });
        }
        
        // Fonction pour analyser les données du tableau HTML
        function parseTableData(html) {
            const parser = new DOMParser();
            const doc = parser.parseFromString(html, 'text/html');
            const table = doc.querySelector('table');
            
            if (!table) {
                console.error('Aucun tableau trouvé dans le document HTML');
                loadSampleData();
                return;
            }
            
            // Récupération des en-têtes (noms des villes)
            const headers = Array.from(table.querySelectorAll('thead th')).slice(1).map(th => th.textContent.trim());
            cities = headers;
            
            // Récupération des connexions entre villes
            const rows = Array.from(table.querySelectorAll('tbody tr'));
            
            rows.forEach((row, i) => {
                const cityName = cities[i];
                connections[cityName] = {};
                
                const cells = Array.from(row.querySelectorAll('td')).slice(1);
                cells.forEach((cell, j) => {
                    // Si une croix "x" est présente dans la cellule, nous considérons qu'il y a une connexion
                    const value = cell.textContent.trim();
                    if (value === 'x') {
                        connections[cityName][cities[j]] = 1; // Connexion directe
                    } else {
                        connections[cityName][cities[j]] = Infinity; // Pas de connexion directe
                    }
                });
                // Une ville est toujours connectée à elle-même avec un poids de 0
                connections[cityName][cityName] = 0;
            });
            
            // Afficher le tableau des connexions pour vérification
            displayTable();
            
            // Remplir les listes déroulantes
            populateDropdowns();
        }
        
        // Charger des données d'exemple si le tableau n'est pas accessible
        function loadSampleData() {
            // Mise à jour avec les nouveaux noms de villes
            cities = ['Achamor', 'Asjakan', 'Asjulus', 'Astalis', 'Ayaprik', 'Ayif', 'Bakhish', 'Bisfard', 'Elam', 'Gard', 'Gbinsu', 'Henburg', 'Kembe', 'Lamoethman', 'Mosafa', 'Mosaiermad', 'Mosyprtab', 'Nokzukiti', 'Ochreseaux', 'Okon', 'Pling', 'Primore', 'Radek', 'Rezillah', 'Raopsvan', 'Sarr', 'Shaipkh', 'Sporia', 'Thas', 'Venton', 'Waoubi', 'wraugelon'];
            
            // Initialiser l'objet connections
            connections = {};
            cities.forEach(city => {
                connections[city] = {};
                cities.forEach(otherCity => {
                    connections[city][otherCity] = Infinity; // Par défaut pas de connexion
                });
                connections[city][city] = 0; // Une ville est toujours connectée à elle-même
            });
            
            // Mise à jour des connexions avec les nouveaux noms de villes
            // Achamor
            connections['Achamor']['Asjakan'] = 1;
            connections['Achamor']['Ayaprik'] = 1;
            connections['Achamor']['Bakhish'] = 1;
            connections['Achamor']['wraugelon'] = 1;
            
            // Asjakan 
            connections['Asjakan']['Achamor'] = 1;
            connections['Asjakan']['Ayaprik'] = 1;
            connections['Asjakan']['Ochreseaux'] = 1;
            connections['Asjakan']['Sporia'] = 1;
            
            // Asjulus 
            connections['Asjulus']['Astalis'] = 1;
            connections['Asjulus']['Bisfard'] = 1;
            connections['Asjulus']['Kembe'] = 1;
            connections['Asjulus']['Thas'] = 1;
            
            // Astalis 
            connections['Astalis']['Asjulus'] = 1;
            connections['Astalis']['Lamoethman'] = 1;
            connections['Astalis']['Mosaiermad'] = 1;
            connections['Astalis']['wraugelon'] = 1;
            
            // Ayaprik 
            connections['Ayaprik']['Achamor'] = 1;
            connections['Ayaprik']['Asjakan'] = 1;
            connections['Ayaprik']['Okon'] = 1;
            connections['Ayaprik']['Raopsvan'] = 1;
            
            // Ayif 
            connections['Ayif']['Lamoethman'] = 1;
            connections['Ayif']['Mosyprtab'] = 1;
            connections['Ayif']['Kembe'] = 1;
            connections['Ayif']['Venton'] = 1;
            
            // Bakhish 
            connections['Bakhish']['Achamor'] = 1;
            connections['Bakhish']['Gbinsu'] = 1;
            connections['Bakhish']['Mosaiermad'] = 1;
            connections['Bakhish']['Pling'] = 1;
           
            // Bisfard
            connections['Bisfard']['Asjulus'] = 1;
            connections['Bisfard']['Gard'] = 1;
            connections['Bisfard']['Mosyprtab'] = 1;
            connections['Bisfard']['Nokzukiti'] = 1;
            
            // Elam
            connections['Elam']['Mosaiermad'] = 1;
            connections['Elam']['Okon'] = 1;
            connections['Elam']['Raopsvan'] = 1;
            connections['Elam']['Thas'] = 1;
            
            // Gard
            connections['Gard']['Bisfard'] = 1;
            connections['Gard']['Ochreseaux'] = 1;
            connections['Gard']['Waoubi'] = 1;
            
            // Gbinsu
            connections['Gbinsu']['Bakhish'] = 1;
            connections['Gbinsu']['Kembe'] = 1;
            connections['Gbinsu']['Primore'] = 1;
            connections['Gbinsu']['Waoubi'] = 1;
            
            // Henburg
            connections['Henburg']['Pling'] = 1;
            connections['Henburg']['Rezillah'] = 1;
            connections['Henburg']['Sarr'] = 1;
            connections['Henburg']['Venton'] = 1;
            
            // Kembe
            connections['Kembe']['Asjulus'] = 1;
            connections['Kembe']['Ayif'] = 1;
            connections['Kembe']['Gbinsu'] = 1;
            connections['Kembe']['Sarr'] = 1;
            
            // Lamoethman
            connections['Lamoethman']['Astalis'] = 1;
            connections['Lamoethman']['Ayif'] = 1;
            connections['Lamoethman']['Mosafa'] = 1;
            connections['Lamoethman']['Primore'] = 1;
            
            // Mosafa
            connections['Mosafa']['Radek'] = 1;
            connections['Mosafa']['Lamoethman'] = 1;
            connections['Mosafa']['Shaipkh'] = 1;
            connections['Mosafa']['Sarr'] = 1;
            
            // Mosaiermad
            connections['Mosaiermad']['Astalis'] = 1;
            connections['Mosaiermad']['Bakhish'] = 1;
            connections['Mosaiermad']['Elam'] = 1;
            connections['Mosaiermad']['Rezillah'] = 1;
            
            // Mosyprtab
            connections['Mosyprtab']['Ayif'] = 1;
            connections['Mosyprtab']['Bisfard'] = 1;
            connections['Mosyprtab']['Rezillah'] = 1;
            connections['Mosyprtab']['Shaipkh'] = 1;
            
            // Nokzukiti
            connections['Nokzukiti']['Bisfard'] = 1;
            connections['Nokzukiti']['Rezillah'] = 1;
            connections['Nokzukiti']['Venton'] = 1;
            connections['Nokzukiti']['wraugelon'] = 1;
            
            // Ochreseaux
            connections['Ochreseaux']['Asjakan'] = 1;
            connections['Ochreseaux']['Gard'] = 1;
            connections['Ochreseaux']['Radek'] = 1;
            connections['Ochreseaux']['Waoubi'] = 1;
            
            // Okon
            connections['Okon']['Ayaprik'] = 1;
            connections['Okon']['Elam'] = 1;
            connections['Okon']['Radek'] = 1;
            connections['Okon']['Sarr'] = 1;
            
            // Pling
            connections['Pling']['Bakhish'] = 1;
            connections['Pling']['Henburg'] = 1;
            connections['Pling']['Shaipkh'] = 1;
            connections['Pling']['Thas'] = 1;
            
            // Primore
            connections['Primore']['Gbinsu'] = 1;
            connections['Primore']['Lamoethman'] = 1;
            connections['Primore']['Raopsvan'] = 1;
            connections['Primore']['Sporia'] = 1;
            
            // Radek
            connections['Radek']['Mosafa'] = 1;
            connections['Radek']['Ochreseaux'] = 1;
            connections['Radek']['Okon'] = 1;
            connections['Radek']['Venton'] = 1;
            
            // Rezillah
            connections['Rezillah']['Henburg'] = 1;
            connections['Rezillah']['Mosaiermad'] = 1;
            connections['Rezillah']['Mosyprtab'] = 1;
            connections['Rezillah']['Nokzukiti'] = 1;
            
            // Raopsvan
            connections['Raopsvan']['Ayaprik'] = 1;
            connections['Raopsvan']['Elam'] = 1;
            connections['Raopsvan']['Primore'] = 1;
            connections['Raopsvan']['Thas'] = 1;
            
            // Sarr 
            connections['Sarr']['Henburg'] = 1;
            connections['Sarr']['Kembe'] = 1;
            connections['Sarr']['Mosafa'] = 1;
            connections['Sarr']['Okon'] = 1;
            
            // Shaipkh
            connections['Shaipkh']['Mosafa'] = 1;
            connections['Shaipkh']['Mosyprtab'] = 1;
            connections['Shaipkh']['Okon'] = 1;
            connections['Shaipkh']['Sporia'] = 1;
           
            // Sporia
            connections['Sporia']['Asjakan'] = 1;
            connections['Sporia']['Primore'] = 1;
            connections['Sporia']['Shaipkh'] = 1;
            connections['Sporia']['wraugelon'] = 1;
            
            // Thas
            connections['Thas']['Asjulus'] = 1;
            connections['Thas']['Elam'] = 1;
            connections['Thas']['Okon'] = 1;
            connections['Thas']['Raopsvan'] = 1;
            
            // Venton
            connections['Venton']['Ayif'] = 1;
            connections['Venton']['Henburg'] = 1;
            connections['Venton']['Nokzukiti'] = 1;
            connections['Venton']['Radek'] = 1;
            
            // Waoubi
            connections['Waoubi']['Gard'] = 1;
            connections['Waoubi']['Gbinsu'] = 1;
            connections['Waoubi']['Ochreseaux'] = 1;
            
            // wraugelon
            connections['wraugelon']['Achamor'] = 1;
            connections['wraugelon']['Astalis'] = 1;
            connections['wraugelon']['Nokzukiti'] = 1;
            connections['wraugelon']['Sporia'] = 1;
            
            // Afficher le tableau des connexions pour vérification
            displayTable();
            
            // Remplir les listes déroulantes
            populateDropdowns();
        }
        
        // Fonction pour afficher le tableau des connexions
        function displayTable() {
            const tableContainer = document.getElementById('dataTable');
            
            // Créer le tableau HTML
            let tableHTML = '<h2>Carte des Connexions de Veloren</h2>';
            tableHTML += '<table>';
            
            // En-tête
            tableHTML += '<thead><tr><th></th>';
            cities.forEach(city => {
                tableHTML += `<th>${city}</th>`;
            });
            tableHTML += '</tr></thead>';
            
            // Corps du tableau
            tableHTML += '<tbody>';
            cities.forEach(cityFrom => {
                tableHTML += `<tr><td><strong>${cityFrom}</strong></td>`;
                cities.forEach(cityTo => {
                    const connected = connections[cityFrom][cityTo];
                    let displayValue;
                    
                    if (connected === 0) {
                        displayValue = '-'; // Même ville
                    } else if (connected === 1) {
                        displayValue = '✓'; // Connexion directe
                    } else {
                        displayValue = ''; // Pas de connexion directe
                    }
                    
                    tableHTML += `<td>${displayValue}</td>`;
                });
                tableHTML += '</tr>';
            });
            tableHTML += '</tbody></table>';
            
            tableContainer.innerHTML = tableHTML;
        }
        
        // Remplir les listes déroulantes avec les noms des villes
        function populateDropdowns() {
            const startSelect = document.getElementById('startCity');
            const endSelect = document.getElementById('endCity');
            
            // Vider les listes
            startSelect.innerHTML = '';
            endSelect.innerHTML = '';
            
            // Ajouter les options
            cities.forEach(city => {
                startSelect.add(new Option(city, city));
                endSelect.add(new Option(city, city));
            });
            
            // Sélectionner des villes différentes par défaut
            if (cities.length > 1) {
                endSelect.selectedIndex = 1;
            }
        }
        
        // Fonction pour calculer le chemin le plus court (algorithme de Dijkstra)
        function calculateShortestPath() {
            const startCity = document.getElementById('startCity').value;
            const endCity = document.getElementById('endCity').value;
            
            // Vérifier que les villes sont différentes
            if (startCity === endCity) {
                showResult('Erreur: Veuillez sélectionner deux villes différentes.', '', true);
                return;
            }
            
            // Initialisation
            const dist = {};
            const prev = {};
            const unvisited = new Set();
            
            // Pour chaque ville, initialiser la distance à l'infini
            cities.forEach(city => {
                dist[city] = Infinity;
                prev[city] = null;
                unvisited.add(city);
            });
            
            // Distance de la ville de départ à elle-même = 0
            dist[startCity] = 0;
            
            // Tant qu'il reste des villes non visitées
            while (unvisited.size > 0) {
                // Trouver la ville non visitée avec la plus petite distance
                let current = null;
                let minDist = Infinity;
                
                for (const city of unvisited) {
                    if (dist[city] < minDist) {
                        minDist = dist[city];
                        current = city;
                    }
                }
                
                // Si on ne peut pas atteindre d'autres villes ou si on a atteint la destination
                if (current === null || current === endCity) break;
                
                // Marquer comme visitée
                unvisited.delete(current);
                
                // Pour chaque voisin de la ville actuelle
                for (const neighbor in connections[current]) {
                    if (unvisited.has(neighbor)) {
                        const weight = connections[current][neighbor];
                        const alt = dist[current] + weight;
                        
                        // Si on a trouvé un chemin plus court
                        if (alt < dist[neighbor]) {
                            dist[neighbor] = alt;
                            prev[neighbor] = current;
                        }
                    }
                }
            }
            
            // Reconstruire le chemin
            const path = [];
            let current = endCity;
            
            // Si on ne peut pas atteindre la destination
            if (prev[endCity] === null && startCity !== endCity) {
                showResult('Aucun chemin trouvé entre ces deux villes.', '', true);
                return;
            }
            
            // Reconstruire le chemin de fin à début
            while (current !== null) {
                path.unshift(current);
                current = prev[current];
            }
            
            // Afficher le résultat
            const pathText = path.join(' → ');
            const etapes = path.length - 1;
            const distanceText = `Nombre d'étapes: ${etapes} ville${etapes > 1 ? 's' : ''}`;
            
            showResult(pathText, distanceText);
        }
        
        // Fonction pour afficher le résultat
        function showResult(pathText, distanceText, isError = false) {
            const resultDiv = document.getElementById('result');
            const pathResult = document.getElementById('pathResult');
            const distanceResult = document.getElementById('distanceResult');
            
            resultDiv.style.display = 'block';
            
            if (isError) {
                pathResult.innerHTML = `<span class="error">${pathText}</span>`;
                distanceResult.textContent = '';
            } else {
                pathResult.textContent = pathText;
                distanceResult.textContent = distanceText;
            }
        }
        
        // Charger les données immédiatement pour le test
        loadSampleData();
    </script>
</body>
</html>
